/** @file herwigopts.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.4
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef HERWIGOPTS_H
#define HERWIGOPTS_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE PACKAGE
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#ifdef PACKAGE_NAME
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE_NAME
#else
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE
#endif
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  long numevents_arg;	/**< @brief Number of events to generate..  */
  char * numevents_orig;	/**< @brief Number of events to generate. original value given at command line.  */
  const char *numevents_help; /**< @brief Number of events to generate. help description.  */
  int seed_arg;	/**< @brief The random number generator seed..  */
  char * seed_orig;	/**< @brief The random number generator seed. original value given at command line.  */
  const char *seed_help; /**< @brief The random number generator seed. help description.  */
  char * tag_arg;	/**< @brief A tag to append to the run name. (default='').  */
  char * tag_orig;	/**< @brief A tag to append to the run name. original value given at command line.  */
  const char *tag_help; /**< @brief A tag to append to the run name. help description.  */
  int debug_arg;	/**< @brief Set the ThePEG debug level..  */
  char * debug_orig;	/**< @brief Set the ThePEG debug level. original value given at command line.  */
  const char *debug_help; /**< @brief Set the ThePEG debug level. help description.  */
  int debug_fpe_flag;	/**< @brief Enable floating point exceptions. (default=off).  */
  const char *debug_fpe_help; /**< @brief Enable floating point exceptions. help description.  */
  int quiet_flag;	/**< @brief Disable event counter. (default=off).  */
  const char *quiet_help; /**< @brief Disable event counter. help description.  */
  char ** append_arg;	/**< @brief Append a search path for dynamically loaded libraries..  */
  char ** append_orig;	/**< @brief Append a search path for dynamically loaded libraries. original value given at command line.  */
  unsigned int append_min; /**< @brief Append a search path for dynamically loaded libraries.'s minimum occurreces */
  unsigned int append_max; /**< @brief Append a search path for dynamically loaded libraries.'s maximum occurreces */
  const char *append_help; /**< @brief Append a search path for dynamically loaded libraries. help description.  */
  char ** prepend_arg;	/**< @brief Prepend a search path for dynamically loaded libraries..  */
  char ** prepend_orig;	/**< @brief Prepend a search path for dynamically loaded libraries. original value given at command line.  */
  unsigned int prepend_min; /**< @brief Prepend a search path for dynamically loaded libraries.'s minimum occurreces */
  unsigned int prepend_max; /**< @brief Prepend a search path for dynamically loaded libraries.'s maximum occurreces */
  const char *prepend_help; /**< @brief Prepend a search path for dynamically loaded libraries. help description.  */
  char * init_arg;	/**< @brief Initialization file to read for 'init'. (default='HerwigDefaults.in').  */
  char * init_orig;	/**< @brief Initialization file to read for 'init'. original value given at command line.  */
  const char *init_help; /**< @brief Initialization file to read for 'init'. help description.  */
  char * repo_arg;	/**< @brief Repository file to use. (default='HerwigDefaults.rpo').  */
  char * repo_orig;	/**< @brief Repository file to use. original value given at command line.  */
  const char *repo_help; /**< @brief Repository file to use. help description.  */
  int noexitonerror_flag;	/**< @brief If set, ThePEG will not try to recover from failures, but will exit with a non-zero return code. (default=off).  */
  const char *noexitonerror_help; /**< @brief If set, ThePEG will not try to recover from failures, but will exit with a non-zero return code. help description.  */
  int resume_flag;	/**< @brief Try to resume execution from an earlier interrupted run. (default=off).  */
  const char *resume_help; /**< @brief Try to resume execution from an earlier interrupted run. help description.  */
  int keepid_flag;	/**< @brief Peserve creation order of objects, to allow exactly reproducible runs. (default=off).  */
  const char *keepid_help; /**< @brief Peserve creation order of objects, to allow exactly reproducible runs. help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int numevents_given ;	/**< @brief Whether numevents was given.  */
  unsigned int seed_given ;	/**< @brief Whether seed was given.  */
  unsigned int tag_given ;	/**< @brief Whether tag was given.  */
  unsigned int debug_given ;	/**< @brief Whether debug was given.  */
  unsigned int debug_fpe_given ;	/**< @brief Whether debug-fpe was given.  */
  unsigned int quiet_given ;	/**< @brief Whether quiet was given.  */
  unsigned int append_given ;	/**< @brief Whether append was given.  */
  unsigned int prepend_given ;	/**< @brief Whether prepend was given.  */
  unsigned int init_given ;	/**< @brief Whether init was given.  */
  unsigned int repo_given ;	/**< @brief Whether repo was given.  */
  unsigned int noexitonerror_given ;	/**< @brief Whether noexitonerror was given.  */
  unsigned int resume_given ;	/**< @brief Whether resume was given.  */
  unsigned int keepid_given ;	/**< @brief Whether keepid was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *gengetopt_args_info_full_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void cmdline_parser_print_full_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* HERWIGOPTS_H */
