#ifndef __GM_COLOR_TABLE_H__
#define __GM_COLOR_TABLE_H__

#include <gtk/gtk.h>
#include "gm-options.h"

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_COLOR_TABLE					(gm_color_table_get_type())
#define GM_COLOR_TABLE(obj)					(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_COLOR_TABLE, GmColorTable))
#define GM_COLOR_TABLE_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_COLOR_TABLE, GmColorTable const))
#define GM_COLOR_TABLE_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), \
		GM_TYPE_COLOR_TABLE, GmColorTableClass))
#define GM_IS_COLOR_TABLE(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
		GM_TYPE_COLOR_TABLE))
#define GM_IS_COLOR_TABLE_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), \
		GM_TYPE_COLOR_TABLE))
#define GM_COLOR_TABLE_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), \
		GM_TYPE_COLOR_TABLE, GmColorTableClass))

/* Private structure type */
typedef struct _GmColorTablePrivate GmColorTablePrivate;

/*
 * Main object structure
 */
typedef struct _GmColorTable GmColorTable;
 
struct _GmColorTable {
	GObject object;
	
	/*< private > */
	GmColorTablePrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmColorTableClass 	GmColorTableClass;

struct _GmColorTableClass {
	GObjectClass parent_class;

	/* Signals */
	void (* color_changed) (GmColorTable *table, const gchar *color);
	void (* font_changed) (GmColorTable *table, const gchar *font_description);
};

typedef enum _GmColorTableScheme {
	SCHEME_NONE = 0,
	SCHEME_DEFAULT,
	SCHEME_WHITE_ON_BLACK,
	SCHEME_RXVT,
	SCHEME_XTERM,
	SCHEME_LINUX,
	SCHEME_USER
} GmColorTableScheme;

GType gm_color_table_get_type(void) G_GNUC_CONST;

GmColorTable *gm_color_table_new(void);
GmColorTable *gm_color_table_new_from_options(gchar *filename);
void gm_color_table_save(GmColorTable *table);

void gm_color_table_set(GmColorTable *table, gchar const *name, 
		gchar const *hex);
gboolean gm_color_table_get(GmColorTable *table, gchar const *name, 
		GdkColor *color);
const gchar *gm_color_table_get_hex(GmColorTable *table, gchar const *name);

void gm_color_table_set_font_description(GmColorTable *table, 
		gchar const *font_description);
const gchar *gm_color_table_font_description(GmColorTable *table);

void gm_color_table_set_use_system_font(GmColorTable *table,
		gboolean use_system_font);
gboolean gm_color_table_get_use_system_font(GmColorTable *table);

void gm_color_table_load_scheme(GmColorTable *table, 
		GmColorTableScheme scheme);
void gm_color_table_set_from_scheme_name(GmColorTable *table, 
		gchar const *name);
gchar const *gm_color_table_get_scheme_name(GmColorTable *table);

void gm_color_table_set_from_options(GmColorTable *table, GmOptions *options);

G_END_DECLS
#endif /* __GM_COLOR_TABLE_H__ */

