/* gksu-environment.c generated by valac 0.14.2, the Vala compiler
 * generated from gksu-environment.vala, do not modify */

/*
 * Copyright (C) 2008 Gustavo Noronha Silva
 *
 * This file is part of the Gksu PolicyKit library.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.  You should have received
 * a copy of the GNU General Public License along with this program;
 * if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define GKSU_TYPE_VARIABLE (gksu_variable_get_type ())
#define GKSU_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GKSU_TYPE_VARIABLE, GksuVariable))
#define GKSU_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GKSU_TYPE_VARIABLE, GksuVariableClass))
#define GKSU_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GKSU_TYPE_VARIABLE))
#define GKSU_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GKSU_TYPE_VARIABLE))
#define GKSU_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GKSU_TYPE_VARIABLE, GksuVariableClass))

typedef struct _GksuVariable GksuVariable;
typedef struct _GksuVariableClass GksuVariableClass;
typedef struct _GksuVariablePrivate GksuVariablePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GKSU_TYPE_ENVIRONMENT (gksu_environment_get_type ())
#define GKSU_ENVIRONMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GKSU_TYPE_ENVIRONMENT, GksuEnvironment))
#define GKSU_ENVIRONMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GKSU_TYPE_ENVIRONMENT, GksuEnvironmentClass))
#define GKSU_IS_ENVIRONMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GKSU_TYPE_ENVIRONMENT))
#define GKSU_IS_ENVIRONMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GKSU_TYPE_ENVIRONMENT))
#define GKSU_ENVIRONMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GKSU_TYPE_ENVIRONMENT, GksuEnvironmentClass))

typedef struct _GksuEnvironment GksuEnvironment;
typedef struct _GksuEnvironmentClass GksuEnvironmentClass;
typedef struct _GksuEnvironmentPrivate GksuEnvironmentPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))

struct _GksuVariable {
	GObject parent_instance;
	GksuVariablePrivate * priv;
	gchar* name;
	gchar* regex;
};

struct _GksuVariableClass {
	GObjectClass parent_class;
};

struct _GksuEnvironment {
	GObject parent_instance;
	GksuEnvironmentPrivate * priv;
};

struct _GksuEnvironmentClass {
	GObjectClass parent_class;
};

struct _GksuEnvironmentPrivate {
	GeeHashMap* variables;
};


static gpointer gksu_variable_parent_class = NULL;
static gpointer gksu_environment_parent_class = NULL;

GType gksu_variable_get_type (void) G_GNUC_CONST;
enum  {
	GKSU_VARIABLE_DUMMY_PROPERTY
};
GksuVariable* gksu_variable_new (void);
GksuVariable* gksu_variable_construct (GType object_type);
static void gksu_variable_finalize (GObject* obj);
GType gksu_environment_get_type (void) G_GNUC_CONST;
#define GKSU_ENVIRONMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GKSU_TYPE_ENVIRONMENT, GksuEnvironmentPrivate))
enum  {
	GKSU_ENVIRONMENT_DUMMY_PROPERTY
};
GHashTable* gksu_environment_get_variables (GksuEnvironment* self);
static void _g_free0_ (gpointer var);
gboolean gksu_environment_validate_hash_table (GksuEnvironment* self, GHashTable* hash_table);
gboolean gksu_environment_is_variable_valid (GksuEnvironment* self, const gchar* name, const gchar* value);
static void gksu_environment_read_variables_from_path (GksuEnvironment* self, const gchar* path);
static void gksu_environment_read_variables_from_file (GksuEnvironment* self, const gchar* path);
GksuEnvironment* gksu_environment_new (void);
GksuEnvironment* gksu_environment_construct (GType object_type);
static GObject * gksu_environment_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gksu_environment_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GksuVariable* gksu_variable_construct (GType object_type) {
	GksuVariable * self = NULL;
	self = (GksuVariable*) g_object_new (object_type, NULL);
	return self;
}


GksuVariable* gksu_variable_new (void) {
	return gksu_variable_construct (GKSU_TYPE_VARIABLE);
}


static void gksu_variable_class_init (GksuVariableClass * klass) {
	gksu_variable_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = gksu_variable_finalize;
}


static void gksu_variable_instance_init (GksuVariable * self) {
}


static void gksu_variable_finalize (GObject* obj) {
	GksuVariable * self;
	self = GKSU_VARIABLE (obj);
	_g_free0 (self->name);
	_g_free0 (self->regex);
	G_OBJECT_CLASS (gksu_variable_parent_class)->finalize (obj);
}


GType gksu_variable_get_type (void) {
	static volatile gsize gksu_variable_type_id__volatile = 0;
	if (g_once_init_enter (&gksu_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GksuVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gksu_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GksuVariable), 0, (GInstanceInitFunc) gksu_variable_instance_init, NULL };
		GType gksu_variable_type_id;
		gksu_variable_type_id = g_type_register_static (G_TYPE_OBJECT, "GksuVariable", &g_define_type_info, 0);
		g_once_init_leave (&gksu_variable_type_id__volatile, gksu_variable_type_id);
	}
	return gksu_variable_type_id__volatile;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


GHashTable* gksu_environment_get_variables (GksuEnvironment* self) {
	GHashTable* result = NULL;
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* keysset;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* envpairs;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->variables;
	_tmp1_ = gee_abstract_map_get_keys ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	keysset = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_free0_);
	envpairs = _tmp5_;
	{
		GeeSet* _tmp6_;
		GeeIterator* _tmp7_ = NULL;
		GeeIterator* _variable_it;
		_tmp6_ = keysset;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_variable_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			gboolean _tmp9_ = FALSE;
			GeeIterator* _tmp10_;
			gpointer _tmp11_ = NULL;
			gchar* variable;
			const gchar* _tmp12_;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* value;
			GHashTable* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp8_ = _variable_it;
			_tmp9_ = gee_iterator_next (_tmp8_);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = _variable_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			variable = (gchar*) _tmp11_;
			_tmp12_ = variable;
			_tmp13_ = g_getenv (_tmp12_);
			_tmp14_ = g_strdup (_tmp13_);
			value = _tmp14_;
			_tmp15_ = envpairs;
			_tmp16_ = variable;
			_tmp17_ = g_strdup (_tmp16_);
			_tmp18_ = value;
			_tmp19_ = g_strdup (_tmp18_);
			g_hash_table_insert (_tmp15_, _tmp17_, _tmp19_);
			_g_free0 (value);
			_g_free0 (variable);
		}
		_g_object_unref0 (_variable_it);
	}
	result = envpairs;
	_g_object_unref0 (keysset);
	return result;
}


gboolean gksu_environment_validate_hash_table (GksuEnvironment* self, GHashTable* hash_table) {
	gboolean result = FALSE;
	GHashTable* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* varnames;
	GList* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (hash_table != NULL, FALSE);
	_tmp0_ = hash_table;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	varnames = _tmp1_;
	_tmp2_ = varnames;
	{
		GList* name_collection = NULL;
		GList* name_it = NULL;
		name_collection = _tmp2_;
		for (name_it = name_collection; name_it != NULL; name_it = name_it->next) {
			gchar* _tmp3_;
			gchar* name = NULL;
			_tmp3_ = g_strdup ((const gchar*) name_it->data);
			name = _tmp3_;
			{
				GHashTable* _tmp4_;
				const gchar* _tmp5_;
				gconstpointer _tmp6_ = NULL;
				const gchar* value;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				gboolean _tmp9_ = FALSE;
				_tmp4_ = hash_table;
				_tmp5_ = name;
				_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
				value = (const gchar*) _tmp6_;
				_tmp7_ = name;
				_tmp8_ = value;
				_tmp9_ = gksu_environment_is_variable_valid (self, _tmp7_, _tmp8_);
				if (!_tmp9_) {
					result = FALSE;
					_g_free0 (name);
					_g_list_free0 (varnames);
					return result;
				}
				_g_free0 (name);
			}
		}
	}
	result = TRUE;
	_g_list_free0 (varnames);
	return result;
}


gboolean gksu_environment_is_variable_valid (GksuEnvironment* self, const gchar* name, const gchar* value) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	GksuVariable* _tmp3_;
	gboolean _tmp4_;
	GeeHashMap* _tmp5_;
	const gchar* _tmp6_;
	gpointer _tmp7_ = NULL;
	GksuVariable* variable;
	gboolean _tmp8_ = FALSE;
	GksuVariable* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp0_ = self->priv->variables;
	_tmp1_ = name;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	_tmp3_ = (GksuVariable*) _tmp2_;
	_tmp4_ = _tmp3_ == NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->variables;
	_tmp6_ = name;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp6_);
	variable = (GksuVariable*) _tmp7_;
	_tmp9_ = variable;
	_tmp10_ = _tmp9_->regex;
	if (_tmp10_ != NULL) {
		GksuVariable* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = variable;
		_tmp12_ = _tmp11_->regex;
		_tmp8_ = g_strcmp0 (_tmp12_, "") != 0;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp13_ = _tmp8_;
	if (_tmp13_) {
		{
			GksuVariable* _tmp14_;
			const gchar* _tmp15_;
			GRegex* _tmp16_;
			GRegex* regex;
			GRegex* _tmp17_;
			const gchar* _tmp18_;
			gboolean _tmp19_ = FALSE;
			_tmp14_ = variable;
			_tmp15_ = _tmp14_->regex;
			_tmp16_ = g_regex_new (_tmp15_, 0, 0, &_inner_error_);
			regex = _tmp16_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				_g_object_unref0 (variable);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp17_ = regex;
			_tmp18_ = value;
			_tmp19_ = g_regex_match (_tmp17_, _tmp18_, 0, NULL);
			result = _tmp19_;
			_g_regex_unref0 (regex);
			_g_object_unref0 (variable);
			return result;
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			GError* _error_ = NULL;
			const gchar* _tmp20_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp20_ = name;
			g_warning ("gksu-environment.vala:81: bad regular expression for variable %s", _tmp20_);
			result = FALSE;
			_g_error_free0 (_error_);
			_g_object_unref0 (variable);
			return result;
		}
		__finally0:
		_g_object_unref0 (variable);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	_g_object_unref0 (variable);
	return result;
}


static void gksu_environment_read_variables_from_path (GksuEnvironment* self, const gchar* path) {
	GDir* directory = NULL;
	const gchar* entry = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	{
		const gchar* _tmp0_;
		GDir* _tmp1_ = NULL;
		GDir* _tmp2_;
		_tmp0_ = path;
		_tmp1_ = g_dir_open (_tmp0_, (guint) 0, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_dir_close0 (directory);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_dir_close0 (directory);
		directory = _tmp2_;
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
		_g_dir_close0 (directory);
		return;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_dir_close0 (directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	while (TRUE) {
		GDir* _tmp3_;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp3_ = directory;
		_tmp4_ = g_dir_read_name (_tmp3_);
		entry = _tmp4_;
		_tmp5_ = entry;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp6_ = entry;
		_tmp7_ = g_str_has_suffix (_tmp6_, ".variables");
		if (_tmp7_) {
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* full_path;
			const gchar* _tmp11_;
			_tmp8_ = path;
			_tmp9_ = entry;
			_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
			full_path = _tmp10_;
			_tmp11_ = full_path;
			gksu_environment_read_variables_from_file (self, _tmp11_);
			_g_free0 (full_path);
		}
	}
	_g_dir_close0 (directory);
}


static void gksu_environment_read_variables_from_file (GksuEnvironment* self, const gchar* path) {
	GKeyFile* _tmp0_;
	GKeyFile* file;
	gchar** variable_names = NULL;
	gint variable_names_length1 = 0;
	gint _variable_names_size_ = 0;
	GKeyFile* _tmp7_;
	gsize _tmp8_;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_key_file_new ();
	file = _tmp0_;
	{
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = file;
		_tmp2_ = path;
		g_key_file_load_from_file (_tmp1_, _tmp2_, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch2_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
			_g_key_file_free0 (file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally2;
	__catch2_g_key_file_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		g_warning ("gksu-environment.vala:115: %s", _tmp4_);
		_g_error_free0 (_error_);
		variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
		_g_key_file_free0 (file);
		return;
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		g_warning ("gksu-environment.vala:118: %s", _tmp6_);
		_g_error_free0 (_error_);
		variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
		_g_key_file_free0 (file);
		return;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
		_g_key_file_free0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = file;
	_tmp9_ = g_key_file_get_groups (_tmp7_, &_tmp8_);
	variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
	variable_names = _tmp9_;
	variable_names_length1 = _tmp8_;
	_variable_names_size_ = variable_names_length1;
	_tmp10_ = variable_names;
	_tmp10__length1 = variable_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp10_;
		name_collection_length1 = _tmp10__length1;
		for (name_it = 0; name_it < _tmp10__length1; name_it = name_it + 1) {
			gchar* _tmp11_;
			gchar* name = NULL;
			_tmp11_ = g_strdup (name_collection[name_it]);
			name = _tmp11_;
			{
				gchar* policy = NULL;
				const gchar* _tmp16_;
				GksuVariable* _tmp17_;
				GksuVariable* variable;
				GksuVariable* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				GeeHashMap* _tmp26_;
				const gchar* _tmp27_;
				GksuVariable* _tmp28_;
				{
					GKeyFile* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_;
					_tmp12_ = file;
					_tmp13_ = name;
					_tmp14_ = g_key_file_get_value (_tmp12_, _tmp13_, "Policy", &_inner_error_);
					_tmp15_ = _tmp14_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch3_g_key_file_error;
						}
						_g_free0 (policy);
						_g_free0 (name);
						variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_free0 (file);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_free0 (policy);
					policy = _tmp15_;
				}
				goto __finally3;
				__catch3_g_key_file_error:
				{
					GError* _error_ = NULL;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_g_free0 (policy);
					policy = NULL;
					_g_error_free0 (_error_);
				}
				__finally3:
				if (_inner_error_ != NULL) {
					_g_free0 (policy);
					_g_free0 (name);
					variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
					_g_key_file_free0 (file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp16_ = policy;
				if (g_strcmp0 (_tmp16_, "send") != 0) {
					_g_free0 (policy);
					_g_free0 (name);
					continue;
				}
				_tmp17_ = gksu_variable_new ();
				variable = _tmp17_;
				_tmp18_ = variable;
				_tmp19_ = name;
				_tmp20_ = g_strdup (_tmp19_);
				_g_free0 (_tmp18_->name);
				_tmp18_->name = _tmp20_;
				{
					GKeyFile* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_;
					GksuVariable* _tmp25_;
					_tmp21_ = file;
					_tmp22_ = name;
					_tmp23_ = g_key_file_get_value (_tmp21_, _tmp22_, "Regex", &_inner_error_);
					_tmp24_ = _tmp23_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch4_g_key_file_error;
						}
						_g_object_unref0 (variable);
						_g_free0 (policy);
						_g_free0 (name);
						variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_free0 (file);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp25_ = variable;
					_g_free0 (_tmp25_->regex);
					_tmp25_->regex = _tmp24_;
				}
				goto __finally4;
				__catch4_g_key_file_error:
				{
					GError* _error_ = NULL;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (_error_);
				}
				__finally4:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (variable);
					_g_free0 (policy);
					_g_free0 (name);
					variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
					_g_key_file_free0 (file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp26_ = self->priv->variables;
				_tmp27_ = name;
				_tmp28_ = variable;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, _tmp27_, _tmp28_);
				_g_object_unref0 (variable);
				_g_free0 (policy);
				_g_free0 (name);
			}
		}
	}
	variable_names = (_vala_array_free (variable_names, variable_names_length1, (GDestroyNotify) g_free), NULL);
	_g_key_file_free0 (file);
}


GksuEnvironment* gksu_environment_construct (GType object_type) {
	GksuEnvironment * self = NULL;
	self = (GksuEnvironment*) g_object_new (object_type, NULL);
	return self;
}


GksuEnvironment* gksu_environment_new (void) {
	return gksu_environment_construct (GKSU_TYPE_ENVIRONMENT);
}


static GObject * gksu_environment_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GksuEnvironment * self;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** search_path;
	gint search_path_length1;
	gint _search_path_size_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GeeHashMap* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	parent_class = G_OBJECT_CLASS (gksu_environment_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GKSU_ENVIRONMENT (obj);
	_tmp1_ = _tmp0_ = g_get_system_data_dirs ();
	search_path = _tmp1_;
	search_path_length1 = _vala_array_length (_tmp0_);
	_search_path_size_ = search_path_length1;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GKSU_TYPE_VARIABLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp2_, _tmp3_, NULL);
	_g_object_unref0 (self->priv->variables);
	self->priv->variables = _tmp4_;
	_tmp5_ = search_path;
	_tmp5__length1 = search_path_length1;
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp5_;
		path_collection_length1 = _tmp5__length1;
		for (path_it = 0; path_it < _tmp5__length1; path_it = path_it + 1) {
			gchar* _tmp6_;
			gchar* path = NULL;
			_tmp6_ = g_strdup (path_collection[path_it]);
			path = _tmp6_;
			{
				const gchar* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* full_path;
				const gchar* _tmp9_;
				_tmp7_ = path;
				_tmp8_ = g_strconcat (_tmp7_, "gksu-polkit-1/environment/", NULL);
				full_path = _tmp8_;
				_tmp9_ = full_path;
				gksu_environment_read_variables_from_path (self, _tmp9_);
				_g_free0 (full_path);
				_g_free0 (path);
			}
		}
	}
	return obj;
}


static void gksu_environment_class_init (GksuEnvironmentClass * klass) {
	gksu_environment_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GksuEnvironmentPrivate));
	G_OBJECT_CLASS (klass)->constructor = gksu_environment_constructor;
	G_OBJECT_CLASS (klass)->finalize = gksu_environment_finalize;
}


static void gksu_environment_instance_init (GksuEnvironment * self) {
	self->priv = GKSU_ENVIRONMENT_GET_PRIVATE (self);
}


static void gksu_environment_finalize (GObject* obj) {
	GksuEnvironment * self;
	self = GKSU_ENVIRONMENT (obj);
	_g_object_unref0 (self->priv->variables);
	G_OBJECT_CLASS (gksu_environment_parent_class)->finalize (obj);
}


GType gksu_environment_get_type (void) {
	static volatile gsize gksu_environment_type_id__volatile = 0;
	if (g_once_init_enter (&gksu_environment_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GksuEnvironmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gksu_environment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GksuEnvironment), 0, (GInstanceInitFunc) gksu_environment_instance_init, NULL };
		GType gksu_environment_type_id;
		gksu_environment_type_id = g_type_register_static (G_TYPE_OBJECT, "GksuEnvironment", &g_define_type_info, 0);
		g_once_init_leave (&gksu_environment_type_id__volatile, gksu_environment_type_id);
	}
	return gksu_environment_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



