/*  GFC-UI: Gtk+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/// @file gfc/ui.hh
/// @brief A convenient header file that includes the main user interface elements.
///
/// This convenient header file includes the header files generally needed by 
/// most applications. Note, \<gfc/gtk/dialog.hh\> includes all the header files
/// in it's inheritance path. These are: \<gfc/gtk/window.hh\>, \<gfc/gtk/bin.hh\>, 
/// \<gfc/gtk/container.hh\>, \<gfc/gtk/widget.hh\>, \<gfc/gtk/object.hh\> and
/// \<gfc/glib/object.hh\>.

#ifndef GFC_UI_HH
#define GFC_UI_HH

#ifndef GFC_GTK_DIALOG_HH
#include <gfc/gtk/dialog.hh>
#endif

#ifndef GFC_GTK_BOX_HH
#include <gfc/gtk/box.hh>
#endif

#endif // GFC_UI_HH
