/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  treeviewsignals.cc - Gtk::TreeView virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by416
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "treeview.hh"
#include "treeviewsignals.hh"
#include "treemodel.hh"
#include "private/treeviewclass.hh"

using namespace GFC;

/*  Gtk::TreeeViewSignals
 */

Gtk::TreeViewSignals::TreeViewSignals(TreeView *tree_view)
: ContainerSignals(tree_view)
{
	Gtk::TreeViewClass::init(GTK_TREE_VIEW_GET_CLASS(tree_view->gtk_tree_view()));
}

Gtk::TreeViewSignals::~TreeViewSignals() 
{
}

void
Gtk::TreeViewSignals::on_set_scroll_adjustments(Adjustment *hadjustment, Adjustment *vadjustment)
{
	GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(instance_);
	if (g_class->set_scroll_adjustments)
		g_class->set_scroll_adjustments((GtkTreeView*)instance_, *hadjustment, *vadjustment);
}

void
Gtk::TreeViewSignals::on_row_activated(const TreePath& path, TreeViewColumn& column)
{
	GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(instance_);
	if (g_class->row_activated)
		g_class->row_activated((GtkTreeView*)instance_, path.gtk_tree_path(), column.gtk_tree_view_column());
}

bool
Gtk::TreeViewSignals::on_test_expand_row(const TreeIter& iter, const TreePath& path)
{
	bool result = false;
	GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(instance_);
	if (g_class->test_expand_row)
		result = g_class->test_expand_row((GtkTreeView*)instance_, iter.gtk_tree_iter(), path.gtk_tree_path());
	return result;
}

bool
Gtk::TreeViewSignals::on_test_collapse_row(const TreeIter& iter, const TreePath& path)
{
	bool result = false;
	GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(instance_);
	if (g_class->test_collapse_row)
		result = g_class->test_collapse_row((GtkTreeView*)instance_, iter.gtk_tree_iter(), path.gtk_tree_path());
	return result;
}

void
Gtk::TreeViewSignals::on_row_expanded(const TreeIter& iter, const TreePath& path)
{
	GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(instance_);
	if (g_class->row_expanded)
		g_class->row_expanded((GtkTreeView*)instance_, iter.gtk_tree_iter(), path.gtk_tree_path());
}

void
Gtk::TreeViewSignals::on_row_collapsed(const TreeIter& iter, const TreePath& path)
{
	GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(instance_);
	if (g_class->row_collapsed)
		g_class->row_collapsed((GtkTreeView*)instance_, iter.gtk_tree_iter(), path.gtk_tree_path());
}

void
Gtk::TreeViewSignals::on_columns_changed()
{
	GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(instance_);
	if (g_class->columns_changed)
		g_class->columns_changed((GtkTreeView*)instance_);
}

void
Gtk::TreeViewSignals::on_cursor_changed()
{
	GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(instance_);
	if (g_class->cursor_changed)
		g_class->cursor_changed((GtkTreeView*)instance_);
}

/*  Gtk::TreeViewClass
 */

void
Gtk::TreeViewClass::init(GtkTreeViewClass *g_class)
{
	g_class->set_scroll_adjustments = &set_scroll_adjustments_proxy;
	g_class->row_activated = &row_activated_proxy;
	g_class->test_expand_row = &test_expand_row_proxy;
	g_class->test_collapse_row = &test_collapse_row_proxy;
	g_class->row_expanded = &row_expanded_proxy;
	g_class->row_collapsed = &row_collapsed_proxy;
	g_class->columns_changed = &columns_changed_proxy;
	g_class->cursor_changed = &cursor_changed_proxy;
}

GtkTreeViewClass*
Gtk::TreeViewClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_TREE_VIEW_GET_CLASS(instance));
	return static_cast<GtkTreeViewClass*>(ptr);
}

GType
Gtk::TreeViewClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_TREE_VIEW);
	}
	return type;
}

void*
Gtk::TreeViewClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::TreeViewClass::set_scroll_adjustments_proxy(GtkTreeView *tree_view, GtkAdjustment *hadjustment, GtkAdjustment *vadjustment)
{
	void *ptr = g_object_get_qdata((GObject*)tree_view, G::ObjectSignals::quark());
	if (ptr)
		static_cast<TreeViewSignals*>(ptr)->on_set_scroll_adjustments(G::Object::wrap<Adjustment>(hadjustment),
		                                                              G::Object::wrap<Adjustment>(vadjustment));
	else
	{
		GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(tree_view);
		if (g_class->set_scroll_adjustments)
			g_class->set_scroll_adjustments(tree_view, hadjustment, vadjustment);
	}
}

void
Gtk::TreeViewClass::row_activated_proxy(GtkTreeView *tree_view, GtkTreePath *path, GtkTreeViewColumn *column)
{
	void *ptr = g_object_get_qdata((GObject*)tree_view, G::ObjectSignals::quark());
	if (ptr)
	{
		TreePath tmp_path(path);
		static_cast<TreeViewSignals*>(ptr)->on_row_activated(tmp_path, *G::Object::wrap<TreeViewColumn>(column));
	}
	else
	{
		GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(tree_view);
		if (g_class->row_activated)
			g_class->row_activated(tree_view, path, column);
	}
}

gboolean
Gtk::TreeViewClass::test_expand_row_proxy(GtkTreeView *tree_view, GtkTreeIter *iter, GtkTreePath *path)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)tree_view, G::ObjectSignals::quark());
	if (ptr)
	{
		TreeIter tmp_iter(iter);
		TreePath tmp_path(path);
		result = static_cast<TreeViewSignals*>(ptr)->on_test_expand_row(tmp_iter, tmp_path);
	}
	else
	{
		GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(tree_view);
		if (g_class->test_expand_row)
			result = g_class->test_expand_row(tree_view, iter, path);
	}
	return result;
}

gboolean
Gtk::TreeViewClass::test_collapse_row_proxy(GtkTreeView *tree_view, GtkTreeIter *iter, GtkTreePath *path)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)tree_view, G::ObjectSignals::quark());
	if (ptr)
	{
		TreeIter tmp_iter(iter);
		TreePath tmp_path(path);
		result = static_cast<TreeViewSignals*>(ptr)->on_test_collapse_row(tmp_iter, tmp_path);
	}
	else
	{
		GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(tree_view);
		if (g_class->test_collapse_row)
			result = g_class->test_collapse_row(tree_view, iter, path);
	}
	return result;
}

void
Gtk::TreeViewClass::row_expanded_proxy(GtkTreeView *tree_view, GtkTreeIter *iter, GtkTreePath *path)
{
	void *ptr = g_object_get_qdata((GObject*)tree_view, G::ObjectSignals::quark());
	if (ptr)
	{
		TreeIter tmp_iter(iter);
		TreePath tmp_path(path);
		static_cast<TreeViewSignals*>(ptr)->on_row_expanded(tmp_iter, tmp_path);
	}
	else
	{
		GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(tree_view);
		if (g_class->row_expanded)
			g_class->row_expanded(tree_view, iter, path);
	}
}

void
Gtk::TreeViewClass::row_collapsed_proxy(GtkTreeView *tree_view, GtkTreeIter *iter, GtkTreePath *path)
{
	void *ptr = g_object_get_qdata((GObject*)tree_view, G::ObjectSignals::quark());
	if (ptr)
	{
		TreeIter tmp_iter(iter);
		TreePath tmp_path(path);
		static_cast<TreeViewSignals*>(ptr)->on_row_collapsed(tmp_iter, tmp_path);
	}
	else
	{
		GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(tree_view);
		if (g_class->row_collapsed)
			g_class->row_collapsed(tree_view, iter, path);
	}
}

void
Gtk::TreeViewClass::columns_changed_proxy(GtkTreeView *tree_view)
{
	void *ptr = g_object_get_qdata((GObject*)tree_view, G::ObjectSignals::quark());
	if (ptr)
		static_cast<TreeViewSignals*>(ptr)->on_columns_changed();
	else
	{
		GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(tree_view);
		if (g_class->columns_changed)
			g_class->columns_changed(tree_view);
	}
}

void
Gtk::TreeViewClass::cursor_changed_proxy(GtkTreeView *tree_view)
{
	void *ptr = g_object_get_qdata((GObject*)tree_view, G::ObjectSignals::quark());
	if (ptr)
		static_cast<TreeViewSignals*>(ptr)->on_cursor_changed();
	else
	{
		GtkTreeViewClass *g_class = TreeViewClass::get_parent_class(tree_view);
		if (g_class->cursor_changed)
			g_class->cursor_changed(tree_view);
	}
}

