/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  combobox.cc - GtkComboBox C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "combobox.hh"
#include "private/comboboxclass.hh"
#include "private/marshal.hh"
#include "liststore.hh"
#include "cellrenderertext.hh"

using namespace GFC;

/*  Gtk::ComboBox
 */

Gtk::ComboBox::ComboBox(GtkComboBox *combo_box, bool owns_reference)
: Bin((GtkBin*)combo_box, owns_reference)
{
}

Gtk::ComboBox::ComboBox()
: Bin((GtkBin*)ComboBoxClass::create())
{
}	
		
Gtk::ComboBox::ComboBox(TreeModel& model)
: Bin((GtkBin*)ComboBoxClass::create())
{
	set_model(model);
}	

Gtk::ComboBox::~ComboBox()
{
}

bool 
Gtk::ComboBox::get_active_iter(TreeIter& iter) const
{
	return gtk_combo_box_get_active_iter(gtk_combo_box(), iter.gtk_tree_iter());
}	

Gtk::TreeModel* 
Gtk::ComboBox::get_model() const
{
	Gtk::TreeModel *tmp_model = 0;
	GtkTreeModel *model = gtk_combo_box_get_model(gtk_combo_box());
	if (model)
	{
		G::Object *object = G::Object::pointer((GObject*)model);
		tmp_model = dynamic_cast<Gtk::TreeModel*>(object);
	}
	return tmp_model;
}

void 
Gtk::ComboBox::set_active_iter(const TreeIter& iter)
{
	gtk_combo_box_set_active_iter(gtk_combo_box(), iter.gtk_tree_iter());
}

void 
Gtk::ComboBox::set_model(TreeModel& model)
{
	gtk_combo_box_set_model(gtk_combo_box(), model.gtk_tree_model());
}
	
void 
Gtk::ComboBox::append_text(const String& text)
{
	append_text(text.c_str());
}

void 
Gtk::ComboBox::prepend_text(const String& text)
{
	prepend_text(text.c_str());
}

void 
Gtk::ComboBox::insert_text(int position, const String& text)
{
	insert_text(position, text.c_str());
}

/*  Gtk::ComboBox signals
 */

const Gtk::ComboBox::ChangedSignalType Gtk::ComboBox::changed_signal("changed", (GCallback)&G::Marshal::void_callback);

/*  Gtk::ComboBoxText
 */
 
Gtk::ComboBoxText::ComboBoxText()
: ComboBox((GtkComboBox*)ComboBoxClass::create())
{
	Pointer<Gtk::ListStore> model = new Gtk::ListStore(1, G_TYPE_STRING);	
	set_model(*model);
	Gtk::CellRendererText *cell_renderer = new Gtk::CellRendererText;	
	pack_start(*cell_renderer);
	add_attribute(*cell_renderer, "text", 0);
}	
	
Gtk::ComboBoxText::~ComboBoxText()
{
}

