/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/// @file gfc/gtk/celleditablesignals.hh
/// @brief Gtk::CellEditable virtual signal handlers.
///
/// Provides Gtk::CellEditableSignals, an abstract base class that implements
/// the overridable virtual signal handlers for Gtk::CellEditable objects.

#ifndef GFC_GTK_CELL_EDITABLE_SIGNALS_HH
#define GFC_GTK_CELL_EDITABLE_SIGNALS_HH

#ifndef GFC_G_TYPE_HH
#include <gfc/glib/type.hh>
#endif

namespace GFC {

namespace Gtk {

/// @class CellEditableSignals celleditablesignals.hh gfc/gtk/celleditablesignals.hh
/// @brief Abstract base class that implements the virtual signal handlers for Gtk::CellEditable.

class CellEditableSignals : public virtual G::TypeInterface
{
protected:
/// @name Constructors
/// @{

	CellEditableSignals(CellEditable *cell_editable);
	///< Construct a new CellEditableSignals object.	
	///< @param cell_editable A CellEditable inheriting the CellEditableSignals implementation.
	
	virtual ~CellEditableSignals() = 0;
	///< Destructor.
	
/// @}

public:
/// @name Signal Handlers
/// @{

	virtual void on_editing_done();
	///< Called when the cell renderer should update it's value from the cell.

	virtual void on_remove_widget();
	///< Called when the cell is finished editing, and the editable widget may now be destroyed.

/// @}
};

} // namespace Gtk

} // namespace GFC

#endif // GFC_GTK_CELL_EDITABLE_SIGNALS_HH

