/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  text.cc - AtkText C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "text.hh"
#include "textsignals.hh"
#include "private/textiface.hh"
#include <gfc/glib/object.hh>
#include <gfc/glib/objectsignals.hh>

using namespace GFC;

/*  Atk::TextSignals
 */

Atk::TextSignals::TextSignals(Text *text)
{
	Atk::TextIface::init(ATK_TEXT_GET_IFACE(text->atk_text()));
}

Atk::TextSignals::~TextSignals()
{
}

void
Atk::TextSignals::on_text_changed(int position, int length)
{
	AtkTextIface *g_iface = TextIface::get_parent_iface(instance_);
	if (g_iface->text_changed)
		g_iface->text_changed((AtkText*)instance_, position, length);
}

void
Atk::TextSignals::on_text_caret_moved(int location)
{
	AtkTextIface *g_iface = TextIface::get_parent_iface(instance_);
	if (g_iface->text_caret_moved)
		g_iface->text_caret_moved((AtkText*)instance_, location);
}

void
Atk::TextSignals::on_text_selection_changed()
{
	AtkTextIface *g_iface = TextIface::get_parent_iface(instance_);
	if (g_iface->text_selection_changed)
		g_iface->text_selection_changed((AtkText*)instance_);
}

void
Atk::TextSignals::on_text_attributes_changed()
{
	AtkTextIface *g_iface = TextIface::get_parent_iface(instance_);
	if (g_iface->text_attributes_changed)
		g_iface->text_attributes_changed((AtkText*)instance_);
}

/*  Atk::TextIface
 */

void
Atk::TextIface::init(AtkTextIface *g_iface)
{
	g_iface->text_changed = &text_changed_proxy;
	g_iface->text_caret_moved = &text_caret_moved_proxy;
	g_iface->text_selection_changed = &text_selection_changed_proxy;
	g_iface->text_attributes_changed = text_attributes_changed_proxy;
}

AtkTextIface*
Atk::TextIface::get_parent_iface(void *instance)
{
	void *ptr = g_type_interface_peek_parent(ATK_TEXT_GET_IFACE(instance));
	return static_cast<AtkTextIface*>(ptr);
}

void
Atk::TextIface::text_changed_proxy(AtkText *text, gint position, gint length)
{
	void *ptr = g_object_get_qdata((GObject*)text, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TextSignals*>(object)->on_text_changed(position, length);
	}
	else
	{
		AtkTextIface *g_iface = TextIface::get_parent_iface(text);
		if (g_iface->text_changed)
			g_iface->text_changed(text, position, length);
	}
}

void
Atk::TextIface::text_caret_moved_proxy(AtkText *text, gint location)
{
	void *ptr = g_object_get_qdata((GObject*)text, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TextSignals*>(object)->on_text_caret_moved(location);
	}
	else
	{
		AtkTextIface *g_iface = TextIface::get_parent_iface(text);
		if (g_iface->text_caret_moved)
			g_iface->text_caret_moved(text, location);
	}
}

void
Atk::TextIface::text_selection_changed_proxy(AtkText *text)
{
	void *ptr = g_object_get_qdata((GObject*)text, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TextSignals*>(object)->on_text_selection_changed();
	}
	else
	{
		AtkTextIface *g_iface = TextIface::get_parent_iface(text);
		if (g_iface->text_selection_changed)
			g_iface->text_selection_changed(text);
	}
}

void
Atk::TextIface::text_attributes_changed_proxy(AtkText *text)
{
	void *ptr = g_object_get_qdata((GObject*)text, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TextSignals*>(object)->on_text_attributes_changed();
	}
	else
	{
		AtkTextIface *g_iface = TextIface::get_parent_iface(text);
		if (g_iface->text_attributes_changed)
			g_iface->text_attributes_changed(text);
	}
}

