/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  objectsignals.cc - Atk::Object virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "object.hh"
#include "objectsignals.hh"
#include "private/objectclass.hh"

using namespace GFC;

/*  Atk::ObjectSignals
 */

Atk::ObjectSignals::ObjectSignals(Object *object)
: G::ObjectSignals(object)
{
	Atk::ObjectClass::init(ATK_OBJECT_GET_CLASS(object->atk_object()));
}

Atk::ObjectSignals::~ObjectSignals()
{
}

void
Atk::ObjectSignals::on_children_changed(unsigned int change_index, gpointer changed_child)
{
	AtkObjectClass *g_class = ObjectClass::get_parent_class(instance_);
	if (g_class->children_changed)
		g_class->children_changed((AtkObject*)instance_, change_index, changed_child);
}

void
Atk::ObjectSignals::on_focus_event(bool focus_in)
{
	AtkObjectClass *g_class = ObjectClass::get_parent_class(instance_);
	if (g_class->focus_event)
		g_class->focus_event((AtkObject*)instance_, focus_in);
}

void
Atk::ObjectSignals::on_property_change(AtkPropertyValues *values)
{
	AtkObjectClass *g_class = ObjectClass::get_parent_class(instance_);
	if (g_class->property_change)
		g_class->property_change((AtkObject*)instance_, values);
}

void
Atk::ObjectSignals::on_state_change(const String& name, bool state_set)
{
	AtkObjectClass *g_class = ObjectClass::get_parent_class(instance_);
	if (g_class->state_change)
		g_class->state_change((AtkObject*)instance_, name.c_str(), state_set);
}

void
Atk::ObjectSignals::on_visible_data_changed()
{
	AtkObjectClass *g_class = ObjectClass::get_parent_class(instance_);
	if (g_class->visible_data_changed)
		g_class->visible_data_changed((AtkObject*)instance_);
}

void
Atk::ObjectSignals::on_active_descendant_changed(void **child)
{
	AtkObjectClass *g_class = ObjectClass::get_parent_class(instance_);
	if (g_class->active_descendant_changed)
		g_class->active_descendant_changed((AtkObject*)instance_, child);
}

/*  Atk::ObjectClass
 */

void
Atk::ObjectClass::init(AtkObjectClass *g_class)
{
	g_class->children_changed = &children_changed_proxy;
	g_class->focus_event = &focus_event_proxy;
	g_class->property_change = &property_change_proxy;
	g_class->state_change = &state_change_proxy;
	g_class->visible_data_changed = &visible_data_changed_proxy;
	g_class->active_descendant_changed = &active_descendant_changed_proxy;
}

AtkObjectClass*
Atk::ObjectClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(ATK_OBJECT_GET_CLASS(instance));
	return static_cast<AtkObjectClass*>(ptr);
}

GType
Atk::ObjectClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(ATK_TYPE_OBJECT);
	}
	return type;
}

void*
Atk::ObjectClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Atk::ObjectClass::children_changed_proxy(AtkObject *accessible, guint change_index, gpointer changed_child)
{
	void *ptr = g_object_get_qdata((GObject*)accessible, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ObjectSignals*>(ptr)->on_children_changed(change_index, changed_child);
	else
	{
		AtkObjectClass *g_class = ObjectClass::get_parent_class(accessible);
		if (g_class->children_changed)
			g_class->children_changed(accessible, change_index, changed_child);
	}
}

void
Atk::ObjectClass::focus_event_proxy(AtkObject *accessible, gboolean focus_in)
{
	void *ptr = g_object_get_qdata((GObject*)accessible, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ObjectSignals*>(ptr)->on_focus_event(focus_in);
	else
	{
		AtkObjectClass *g_class = ObjectClass::get_parent_class(accessible);
		if (g_class->focus_event)
			g_class->focus_event(accessible, focus_in);
	}
}

void
Atk::ObjectClass::property_change_proxy(AtkObject *accessible, AtkPropertyValues *values)
{
	void *ptr = g_object_get_qdata((GObject*)accessible, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ObjectSignals*>(ptr)->on_property_change(values);
	else
	{
		AtkObjectClass *g_class = ObjectClass::get_parent_class(accessible);
		if (g_class->property_change)
			g_class->property_change(accessible, values);
	}
}

void
Atk::ObjectClass::state_change_proxy(AtkObject *accessible, const gchar *name, gboolean state_set)
{
	void *ptr = g_object_get_qdata((GObject*)accessible, G::ObjectSignals::quark());
	if (ptr)
	{
		String tmp_name(name);
		static_cast<ObjectSignals*>(ptr)->on_state_change(tmp_name, state_set);
	}
	else
	{
		AtkObjectClass *g_class = ObjectClass::get_parent_class(accessible);
		if (g_class->state_change)
			g_class->state_change(accessible, name, state_set);
	}
}

void
Atk::ObjectClass::visible_data_changed_proxy(AtkObject *accessible)
{
	void *ptr = g_object_get_qdata((GObject*)accessible, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ObjectSignals*>(ptr)->on_visible_data_changed();
	else
	{
		AtkObjectClass *g_class = ObjectClass::get_parent_class(accessible);
		if (g_class->visible_data_changed)
			g_class->visible_data_changed(accessible);
	}
}

void
Atk::ObjectClass::active_descendant_changed_proxy(AtkObject *accessible, gpointer *child)
{
	void *ptr = g_object_get_qdata((GObject*)accessible, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ObjectSignals*>(ptr)->on_active_descendant_changed(child);
	else
	{
		AtkObjectClass *g_class = ObjectClass::get_parent_class(accessible);
		if (g_class->active_descendant_changed)
			g_class->active_descendant_changed(accessible, child);
	}
}

