/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  object.cc - AtkObject C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "object.hh"
#include "private/objectclass.hh"
#include "private/marshal.hh"
#include "relation.hh"
#include "stateset.hh"

using namespace GFC;

/*  Atk::role_register
 */

Atk::Role
Atk::role_register(const String& name)
{
	return (Role)atk_role_register(name.c_str());
}

/*  Atk::role_get_name
 */

String
Atk::role_get_name(Role role)
{
	return atk_role_get_name((AtkRole)role);
}

/*  Atk::role_get_localized_name
 */

String 
Atk::role_get_localized_name(Role role)
{
	return atk_role_get_localized_name((AtkRole)role);
}

/*  Atk::role_for_name
 */

Atk::Role
Atk::role_for_name(const String& name)
{
	return (Role)atk_role_for_name(name.c_str());
}

/*  Atk::Object
 */

Atk::Object::Object(AtkObject *object, bool owns_reference)
: G::Object((GObject*)object, owns_reference)
{
}

Atk::Object::~Object()
{
}

String
Atk::Object::get_name() const
{
	return atk_object_get_name(atk_object());
}

String
Atk::Object::get_description() const
{
	return atk_object_get_description(atk_object());
}

Atk::Object*
Atk::Object::get_parent() const
{
	AtkObject *parent = atk_object_get_parent(atk_object());
	return parent ? G::Object::wrap<Object>(parent) : 0;
}
	
Atk::Object*
Atk::Object::ref_accessible_child(int index) const
{
	AtkObject *child = atk_object_ref_accessible_child(atk_object(), index);
	return child ? G::Object::wrap<Object>(child) : 0;
}

Atk::RelationSet*
Atk::Object::ref_relation_set() const
{
	AtkRelationSet *set = atk_object_ref_relation_set(atk_object());
	return set ? G::Object::wrap<RelationSet>(set) : 0;
}

Pointer<Atk::StateSet>
Atk::Object::ref_state_set() const
{
	AtkStateSet *set = atk_object_ref_state_set(atk_object());
	return set ? G::Object::wrap<StateSet>(set, true) : 0;
}

void
Atk::Object::set_name(const String& name)
{
	atk_object_set_name(atk_object(), name.c_str());
}

void
Atk::Object::set_description(const String& description)
{
	atk_object_set_description(atk_object(), description.c_str());
}

void
Atk::Object::set_parent(Object& parent)
{
	atk_object_set_parent(atk_object(), parent.atk_object());
}

bool
Atk::Object::add_relationship(RelationType relationship, const Object& target)
{
	return atk_object_add_relationship(atk_object(), (AtkRelationType)relationship, target.atk_object());
}
	
bool 
Atk::Object::remove_relationship(RelationType relationship, const Object& target)
{
	return atk_object_remove_relationship(atk_object(), (AtkRelationType)relationship, target.atk_object());
}

// Atk::Object signals

const Atk::Object::ChildrenChangedSignalType Atk::Object::children_changed_signal("children_changed", (GCallback)&Marshal::void_int_pvoid_callback);

const Atk::Object::FocusEventSignalType Atk::Object::focus_event_signal("focus_event", (GCallback)&G::Marshal::void_bool_callback);

const Atk::Object::PropertyChangeSignalType Atk::Object::property_change_signal("property_change", (GCallback)&Marshal::void_patkpropertyvalues_callback);

const Atk::Object::StateChangeSignalType Atk::Object::state_change_signal("state_change", (GCallback)&Marshal::void_string_bool_callback);

const Atk::Object::VisibleDataChangedSignalType Atk::Object::visible_data_changed_signal("visible_data_changed", (GCallback)&G::Marshal::void_callback);

const Atk::Object::ActiveDescendantChangedSignalType Atk::Object::active_descendant_changed_signal("active_descendant_changed", (GCallback)&Marshal::void_ppvoid_callback);

