from xml import sax



#
# Parser for config files.
#
class ConfigLoader(sax.handler.ContentHandler):

    def __init__(self, config):

        self.__config = config
        self.__path = []



    def load(self, file):

        fd = open(file, "r")
        data = fd.read()
        fd.close()

        sax.parseString(data, self)




    def startElement(self, name, attrs):

        entryname = name
        includefile = attrs.get("include")
        value = attrs.get("value")

        if (name != "config"):
            self.__path.append(entryname)


        if (value):
            self.__config.set(self.__path, value)

        elif (includefile):
            self.__config.set_offset(self.__path)
            self.__config.load(includefile)
            self.__config.set_offset([])



    def endElement(self, name):

        if (self.__path):
            self.__path.pop()




if (__name__ == "__main__"):

    from Config import Config

    cfg = Config()
    cl = ConfigLoader(cfg)
    cl.load("config.xml")

    
